/*
 * Decompiled with CFR 0.152.
 */
package com.hprt.uni.cpcl;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Base64;
import android.util.Log;
import com.alibaba.fastjson.JSONObject;
import cpcl.PrinterHelper;
import cpcl.listener.DisConnectBTListener;
import io.dcloud.feature.uniapp.annotation.UniJSMethod;
import io.dcloud.feature.uniapp.bridge.UniJSCallback;
import io.dcloud.feature.uniapp.common.UniModule;
import java.util.List;

public class PrintModuleCPCL
extends UniModule {
    private String TAG = PrintModuleCPCL.class.getName();
    private boolean isPrint = false;

    @UniJSMethod(uiThread=false)
    public void connectionBT(JSONObject options, UniJSCallback callback) {
        this.printLog("connectionBT:" + options);
        if (options == null || callback == null || this.mUniSDKInstance == null) {
            return;
        }
        try {
            String address = options.getString("address");
            int result = PrinterHelper.portOpenBT((Context)this.mUniSDKInstance.getContext(), (String)address);
            this.resultCallback(callback, result);
        }
        catch (Exception e) {
            String msg = "connectionBT error: " + e.getMessage();
            this.errorCallback(callback, msg);
        }
    }

    @UniJSMethod(uiThread=false)
    public void connectionWIFI(JSONObject options, UniJSCallback callback) {
        this.printLog("connectionBT:" + options);
        if (options == null || callback == null || this.mUniSDKInstance == null) {
            return;
        }
        try {
            String address = options.getString("address");
            int result = PrinterHelper.portOpenWIFI((Context)this.mUniSDKInstance.getContext(), (String)address);
            this.resultCallback(callback, result);
        }
        catch (Exception e) {
            String msg = "connectionBT error: " + e.getMessage();
            this.errorCallback(callback, msg);
        }
    }

    @UniJSMethod(uiThread=false)
    public void closeBT() {
        this.printLog("closeBT");
        try {
            PrinterHelper.portClose();
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("closePort error: " + e.getMessage()));
        }
    }

    @UniJSMethod(uiThread=false)
    public void printText(JSONObject options, UniJSCallback callback) {
        this.printLog("printText:" + options);
        if (this.optionsCallbackEmpty(options, callback)) {
            return;
        }
        try {
            int result = PrinterHelper.Text((String)options.getString("direction"), (String)options.getString("fontSize"), (String)"0", (String)options.getString("x_pos"), (String)options.getString("y_pos"), (String)options.getString("data"));
            this.resultCallback(callback, result);
        }
        catch (Exception e) {
            this.errorCallback(callback, "printText error: " + e.getMessage());
        }
    }

    @UniJSMethod(uiThread=false)
    public void printAreaSize(JSONObject options, UniJSCallback callback) {
        this.printLog("printAreaSize:" + options);
        if (this.optionsCallbackEmpty(options, callback)) {
            return;
        }
        try {
            int result = PrinterHelper.printAreaSize((String)"0", (String)"200", (String)"200", (String)options.getString("height"), (String)options.getString("number"));
            this.resultCallback(callback, result);
        }
        catch (Exception e) {
            this.errorCallback(callback, "printAreaSize error: " + e.getMessage());
        }
    }

    @UniJSMethod(uiThread=false)
    public void printForm() {
        this.printLog("printForm");
        try {
            int n = PrinterHelper.Form();
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("printForm error: " + e.getMessage()));
        }
    }

    @UniJSMethod(uiThread=false)
    public void writeData(JSONObject options, UniJSCallback callback) {
        this.printLog("writeData:" + options);
        if (this.optionsCallbackEmpty(options, callback)) {
            return;
        }
        try {
            List data = (List)options.get((Object)"bData");
            int result = PrinterHelper.WriteData((byte[])this.intToBytes(data));
            this.resultCallback(callback, result);
        }
        catch (Exception e) {
            this.errorCallback(callback, "writeData error: " + e.getMessage());
        }
    }

    @UniJSMethod(uiThread=false)
    public void writeTextData(JSONObject options, UniJSCallback callback) {
        this.printLog("writeTextData " + options);
        if (this.optionsCallbackEmpty(options, callback)) {
            return;
        }
        try {
            String data = options.getString("text");
            int result = PrinterHelper.WriteData((byte[])data.getBytes(PrinterHelper.LanguageEncode));
            this.resultCallback(callback, result);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("writeTextData error: " + e.getMessage()));
        }
    }

    @UniJSMethod(uiThread=false)
    public void readData(JSONObject options, UniJSCallback callback) {
        this.printLog("readData:" + options);
        if (this.optionsCallbackEmpty(options, callback)) {
            return;
        }
        try {
            byte[] result = PrinterHelper.ReadData((int)options.getInteger("time"));
            this.printLog("result:" + PrinterHelper.bytetohex((byte[])result));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("result", (Object)result);
            callback.invoke((Object)jsonObject);
        }
        catch (Exception e) {
            this.errorCallback(callback, "readData error: " + e.getMessage());
        }
    }

    @UniJSMethod(uiThread=false)
    public void print() {
        this.printLog("print");
        try {
            PrinterHelper.Print();
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("print error: " + e.getMessage()));
        }
    }

    @UniJSMethod(uiThread=false)
    public void setCodePage(JSONObject options) {
        this.printLog("setCodePage:" + options);
        if (this.optionsEmpty(options)) {
            return;
        }
        try {
            PrinterHelper.Country((String)options.getString("codePage"));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("print error: " + e.getMessage()));
        }
    }

    @UniJSMethod(uiThread=false)
    public void setLanguageEncode(JSONObject options) {
        this.printLog("setLanguageEncode:" + options);
        if (this.optionsEmpty(options)) {
            return;
        }
        try {
            PrinterHelper.LanguageEncode = options.getString("language");
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("setLanguageEncode error: " + e.getMessage()));
        }
    }

    @UniJSMethod(uiThread=false)
    public void setKhemrEnd() {
        this.printLog("setKhemrEnd");
        try {
            PrinterHelper.setKhemrEnd();
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("setKhemrEnd error: " + e.getMessage()));
        }
    }

    @UniJSMethod(uiThread=false)
    public void getPrinterStatus(UniJSCallback callback) {
        this.printLog("getPrinterStatus");
        try {
            int result = PrinterHelper.getPrinterStatus();
            this.resultCallback(callback, result);
        }
        catch (Exception e) {
            String msg = "getPrinterStatus error: " + e.getMessage();
            this.errorCallback(callback, msg);
        }
    }

    @UniJSMethod(uiThread=false)
    public void printBarCode(JSONObject options) {
        this.printLog("printBarCode " + options);
        if (this.optionsEmpty(options)) {
            return;
        }
        try {
            int n = PrinterHelper.Barcode((String)options.getString("rotation"), (String)options.getString("code_type"), (String)options.getString("width"), (String)options.getString("ratio"), (String)options.getString("height"), (String)options.getString("x_pos"), (String)options.getString("y_pos"), (boolean)options.getBoolean("undertext"), (String)options.getString("number"), (String)"0", (String)options.getString("offset"), (String)options.getString("code_data"));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("printBarCode error: " + e.getMessage()));
        }
    }

    @UniJSMethod(uiThread=false)
    public void printQRCode(JSONObject options) {
        this.printLog("printQRCode " + options);
        if (this.optionsEmpty(options)) {
            return;
        }
        try {
            int n = PrinterHelper.PrintQR((String)options.getString("rotation"), (String)options.getString("x_pos"), (String)options.getString("y_pos"), (String)options.getString("mode"), (String)options.getString("width"), (String)options.getString("code_data"));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("printQRCode error: " + e.getMessage()));
        }
    }

    @UniJSMethod(uiThread=false)
    public void printBitmapBase64(JSONObject options, UniJSCallback callback) {
        this.printLog("printBitmapBase64 " + options);
        if (this.optionsCallbackEmpty(options, callback)) {
            return;
        }
        try {
            String base64 = options.getString("base64");
            byte[] decode = Base64.decode((String)base64, (int)2);
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])decode, (int)0, (int)decode.length);
            if (bitmap == null) {
                Log.e((String)this.TAG, (String)"printBitmapBase64: bitmap == null");
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("result", (Object)"bitmap == null");
                callback.invoke((Object)jsonObject);
                return;
            }
            PrinterHelper.Expanded((String)options.getString("x_pos"), (String)options.getString("y_pos"), (Bitmap)bitmap, (int)options.getInteger("halftoneType"), (int)0);
            this.resultCallback(callback, 0);
        }
        catch (Exception e) {
            String msg = "printBitmapBase64 error: " + e.getMessage();
            this.errorCallback(callback, msg);
        }
    }

    @UniJSMethod(uiThread=false)
    public void printBitmapPath(JSONObject options, UniJSCallback callback) {
        this.printLog("printBitmapPath " + options);
        if (this.optionsCallbackEmpty(options, callback)) {
            return;
        }
        try {
            Bitmap bitmap = BitmapFactory.decodeFile((String)options.getString("path"));
            if (bitmap == null) {
                Log.e((String)this.TAG, (String)"printBitmapPath: bitmap == null");
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("result", (Object)"bitmap == null");
                callback.invoke((Object)jsonObject);
                return;
            }
            PrinterHelper.Expanded((String)options.getString("x_pos"), (String)options.getString("y_pos"), (Bitmap)bitmap, (int)options.getInteger("halftoneType"), (int)0);
            this.resultCallback(callback, 0);
        }
        catch (Exception e) {
            String msg = "printBitmapPath error: " + e.getMessage();
            this.errorCallback(callback, msg);
        }
    }

    @UniJSMethod(uiThread=false)
    public void printBox(JSONObject options) {
        this.printLog("printBox " + options);
        if (this.optionsEmpty(options)) {
            return;
        }
        try {
            int n = PrinterHelper.Box((String)options.getString("leftX"), (String)options.getString("leftY"), (String)options.getString("rightX"), (String)options.getString("rightY"), (String)options.getString("width"));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("printBox error: " + e.getMessage()));
        }
    }

    @UniJSMethod(uiThread=false)
    public void printLine(JSONObject options) {
        this.printLog("printLine " + options);
        if (this.optionsEmpty(options)) {
            return;
        }
        try {
            int n = PrinterHelper.Line((String)options.getString("startX"), (String)options.getString("startY"), (String)options.getString("endX"), (String)options.getString("endY"), (String)options.getString("width"));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("printLine error: " + e.getMessage()));
        }
    }

    @UniJSMethod(uiThread=false)
    public void setMag(JSONObject options) {
        this.printLog("setMag " + options);
        if (this.optionsEmpty(options)) {
            return;
        }
        try {
            int n = PrinterHelper.SetMag((String)options.getString("widthMag"), (String)options.getString("heightMag"));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("setMag error: " + e.getMessage()));
        }
    }

    @UniJSMethod(uiThread=false)
    public void setAlign(JSONObject options) {
        this.printLog("setAlign " + options);
        if (this.optionsEmpty(options)) {
            return;
        }
        try {
            int n = PrinterHelper.Align((String)options.getString("align"));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("setAlign error: " + e.getMessage()));
        }
    }

    @UniJSMethod(uiThread=false)
    public void printPDF417(JSONObject options) {
        this.printLog("printPDF417 " + options);
        if (this.optionsEmpty(options)) {
            return;
        }
        try {
            int n = PrinterHelper.PrintPDF417((String)options.getString("command"), (String)options.getString("start_x"), (String)options.getString("start_y"), (String)options.getString("xd"), (String)options.getString("yd"), (String)options.getString("c"), (String)options.getString("s"), (String)options.getString("data"));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("printPDF417 error: " + e.getMessage()));
        }
    }

    @UniJSMethod(uiThread=false)
    public void setInverseLine(JSONObject options) {
        this.printLog("setInverseLine " + options);
        if (this.optionsEmpty(options)) {
            return;
        }
        try {
            int n = PrinterHelper.InverseLine((String)options.getString("start_x"), (String)options.getString("start_y"), (String)options.getString("end_x"), (String)options.getString("end_y"), (String)options.getString("width"));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("setInverseLine error: " + e.getMessage()));
        }
    }

    @UniJSMethod(uiThread=false)
    public void setContrast(JSONObject options) {
        this.printLog("setContrast " + options);
        if (this.optionsEmpty(options)) {
            return;
        }
        try {
            int n = PrinterHelper.Contrast((String)options.getString("contrast"));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("setContrast error: " + e.getMessage()));
        }
    }

    @UniJSMethod(uiThread=false)
    public void setSpeed(JSONObject options) {
        this.printLog("setSpeed " + options);
        if (this.optionsEmpty(options)) {
            return;
        }
        try {
            int n = PrinterHelper.Speed((String)options.getString("speed"));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("setSpeed error: " + e.getMessage()));
        }
    }

    @UniJSMethod(uiThread=false)
    public void setSp(JSONObject options) {
        this.printLog("setSp " + options);
        if (this.optionsEmpty(options)) {
            return;
        }
        try {
            int n = PrinterHelper.SetSp((String)options.getString("sp"));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("setSp error: " + e.getMessage()));
        }
    }

    @UniJSMethod(uiThread=false)
    public void preFeed(JSONObject options) {
        this.printLog("preFeed " + options);
        if (this.optionsEmpty(options)) {
            return;
        }
        try {
            int n = PrinterHelper.Prefeed((String)options.getString("feed"));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("preFeed error: " + e.getMessage()));
        }
    }

    @UniJSMethod(uiThread=false)
    public void setBold(JSONObject options) {
        this.printLog("setBold " + options);
        if (this.optionsEmpty(options)) {
            return;
        }
        try {
            int n = PrinterHelper.SetBold((String)options.getString("bold"));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("setBold error: " + e.getMessage()));
        }
    }

    @UniJSMethod(uiThread=false)
    public void setTextBox(JSONObject options) {
        this.printLog("setTextBox " + options);
        if (this.optionsEmpty(options)) {
            return;
        }
        try {
            int n = PrinterHelper.AutLine2((String)options.getString("startX"), (String)options.getString("startY"), (String)options.getString("width"), (int)options.getInteger("fontSize"), (boolean)options.getBoolean("isBole"), (boolean)options.getBoolean("isDouble"), (String)options.getString("str"));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("setTextBox error: " + e.getMessage()));
        }
    }

    @UniJSMethod(uiThread=false)
    public void setPageType(JSONObject options) {
        this.printLog("setPageType " + options);
        if (this.optionsEmpty(options)) {
            return;
        }
        try {
            PrinterHelper.papertype_CPCL((int)options.getInteger("pageType"));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("setPageType error: " + e.getMessage()));
        }
    }

    @UniJSMethod(uiThread=false)
    public void poPrint() {
        this.printLog("poPrint");
        try {
            PrinterHelper.PoPrint();
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("poPrint error: " + e.getMessage()));
        }
    }

    @UniJSMethod(uiThread=false)
    public void openEndStatic(JSONObject options) {
        this.printLog("openEndStatic " + options);
        if (this.optionsEmpty(options)) {
            return;
        }
        try {
            PrinterHelper.openEndStatic((boolean)options.getBoolean("isOpen"));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("openEndStatic error: " + e.getMessage()));
        }
    }

    @UniJSMethod(uiThread=false)
    public void getEndStatus(JSONObject options, UniJSCallback callback) {
        this.printLog("getEndStatus " + options);
        if (this.optionsEmpty(options)) {
            return;
        }
        if (this.callbackEmpty(callback)) {
            return;
        }
        try {
            int result = PrinterHelper.getEndStatus((int)options.getInteger("outTime"));
            this.resultCallback(callback, result);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("getEndStatus error: " + e.getMessage()));
            this.errorCallback(callback, e.getMessage());
        }
    }

    @UniJSMethod(uiThread=false)
    public void printBackground(JSONObject options) {
        this.printLog("printBackground " + options);
        if (this.optionsEmpty(options)) {
            return;
        }
        try {
            PrinterHelper.PrintBackground((int)options.getInteger("startX"), (int)options.getInteger("startY"), (int)options.getInteger("fontSize"), (int)options.getInteger("background"), (String)options.getString("data"));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("printBackground error: " + e.getMessage()));
        }
    }

    @UniJSMethod(uiThread=false)
    public void getPrintSN(UniJSCallback callback) {
        this.printLog("getPrintSN " + callback);
        if (this.callbackEmpty(callback)) {
            return;
        }
        try {
            String sn = PrinterHelper.getPrintSN();
            this.resultCallback(callback, sn);
        }
        catch (Exception e) {
            this.errorCallback(callback, e.getMessage());
        }
    }

    @UniJSMethod(uiThread=false)
    public void setCountry(JSONObject options) {
        this.printLog("setCountry " + options);
        if (this.optionsEmpty(options)) {
            return;
        }
        try {
            PrinterHelper.Country((String)options.getString("codepage"));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("setCountry error: " + e.getMessage()));
        }
    }

    @UniJSMethod(uiThread=false)
    public void setBluetoothName(JSONObject options) {
        this.printLog("setBluetoothName " + options);
        if (this.optionsEmpty(options)) {
            return;
        }
        try {
            PrinterHelper.setBluetoothName((String)options.getString("name"));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("setBluetoothName error: " + e.getMessage()));
        }
    }

    @UniJSMethod(uiThread=false)
    public void saveParameter() {
        this.printLog("saveParameter ");
        try {
            PrinterHelper.saveParameter();
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("saveParameter error: " + e.getMessage()));
        }
    }

    @UniJSMethod(uiThread=false)
    public void setLayer(JSONObject options) {
        this.printLog("setLayer " + options);
        if (this.optionsEmpty(options)) {
            return;
        }
        try {
            PrinterHelper.setLayer((int)options.getInteger("layer"));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("setLayer error: " + e.getMessage()));
        }
    }

    @UniJSMethod(uiThread=false)
    public void getElectricity(UniJSCallback callback) {
        this.printLog("getElectricity " + callback);
        if (this.callbackEmpty(callback)) {
            return;
        }
        try {
            int electricity = PrinterHelper.getElectricity();
            this.resultCallback(callback, electricity);
        }
        catch (Exception e) {
            this.errorCallback(callback, e.getMessage());
        }
    }

    @UniJSMethod(uiThread=false)
    public void getVoltage(UniJSCallback callback) {
        this.printLog("getVoltage " + callback);
        if (this.callbackEmpty(callback)) {
            return;
        }
        try {
            String voltage = PrinterHelper.getVoltage();
            this.resultCallback(callback, voltage);
        }
        catch (Exception e) {
            this.errorCallback(callback, e.getMessage());
        }
    }

    @UniJSMethod(uiThread=false)
    public void setDisConnectBTListener(final UniJSCallback callback) {
        this.printLog("setDisConnectBTListener " + callback);
        if (this.callbackEmpty(callback)) {
            return;
        }
        try {
            PrinterHelper.setDisConnectBTListener((DisConnectBTListener)new DisConnectBTListener(){

                public void disConnect() {
                    PrintModuleCPCL.this.resultCallback(callback, 0);
                }
            });
        }
        catch (Exception e) {
            this.errorCallback(callback, e.getMessage());
        }
    }

    @UniJSMethod(uiThread=false)
    public void getPrinterVersion(UniJSCallback callback) {
        this.printLog("getPrinterVersion " + callback);
        if (this.callbackEmpty(callback)) {
            return;
        }
        try {
            String version = PrinterHelper.getPrinterVersion();
            this.resultCallback(callback, version);
        }
        catch (Exception e) {
            this.errorCallback(callback, e.getMessage());
        }
    }

    @UniJSMethod(uiThread=false)
    public void setLog(JSONObject options) {
        this.isPrint = options.getBoolean("isPrint");
    }

    private void printLog(String str) {
        if (this.isPrint) {
            PrinterHelper.isLog = true;
            Log.d((String)this.TAG, (String)str);
        }
    }

    private byte[] intToBytes(List<Integer> data) {
        byte[] re = new byte[data.size()];
        for (int i = 0; i < data.size(); ++i) {
            int integer = data.get(i);
            re[i] = (byte)integer;
        }
        return re;
    }

    private boolean optionsEmpty(JSONObject options) {
        if (options == null) {
            Log.e((String)this.TAG, (String)"options == null");
            return true;
        }
        return false;
    }

    private boolean callbackEmpty(UniJSCallback callback) {
        if (callback == null) {
            Log.e((String)this.TAG, (String)"callback == null");
            return true;
        }
        return false;
    }

    private boolean optionsCallbackEmpty(JSONObject options, UniJSCallback callback) {
        if (options == null || callback == null) {
            Log.e((String)this.TAG, (String)"options == null || callback == null");
            return true;
        }
        return false;
    }

    private void resultCallback(UniJSCallback callback, int result) {
        this.printLog("result " + result);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("result", (Object)result);
        callback.invoke((Object)jsonObject);
    }

    private void resultCallback(UniJSCallback callback, String result) {
        this.printLog("result " + result);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("result", (Object)result);
        callback.invoke((Object)jsonObject);
    }

    private void errorCallback(UniJSCallback callback, String result) {
        Log.e((String)this.TAG, (String)result);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("result", (Object)result);
        callback.invoke((Object)jsonObject);
    }
}

