/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cli;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.cli.CommandLineOption;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.cli.ParsedCommandLineOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineParser {
    private Map<String, CommandLineOption> optionsByString = new HashMap<String, CommandLineOption>();
    private boolean allowMixedOptions;
    private boolean allowUnknownOptions;
    private final PrintWriter deprecationPrinter;

    public CommandLineParser() {
        this(new OutputStreamWriter(System.out));
    }

    public CommandLineParser(Writer writer) {
        this.deprecationPrinter = new PrintWriter(writer);
    }

    public ParsedCommandLine parse(String ... stringArray) throws CommandLineArgumentException {
        return this.parse(Arrays.asList(stringArray));
    }

    public ParsedCommandLine parse(Iterable<String> iterable) throws CommandLineArgumentException {
        ParsedCommandLine parsedCommandLine = new ParsedCommandLine(new HashSet<CommandLineOption>(this.optionsByString.values()));
        ParserState parserState = new BeforeFirstSubCommand(parsedCommandLine);
        for (String string : iterable) {
            if (parserState.maybeStartOption(string)) {
                OptionParserState optionParserState;
                Object object;
                Object object2;
                if (string.equals("--")) {
                    parserState = new AfterOptions(parsedCommandLine);
                    continue;
                }
                if (string.matches("--[^=]+")) {
                    object2 = parserState.onStartOption(string, string.substring(2));
                    parserState = ((OptionParserState)object2).onStartNextArg();
                    continue;
                }
                if (string.matches("--[^=]+=.*")) {
                    int n = string.indexOf(61);
                    object = parserState.onStartOption(string, string.substring(2, n));
                    parserState = ((OptionParserState)object).onArgument(string.substring(n + 1));
                    continue;
                }
                if (string.matches("-[^=]=.*")) {
                    object2 = parserState.onStartOption(string, string.substring(1, 2));
                    parserState = ((OptionParserState)object2).onArgument(string.substring(3));
                    continue;
                }
                assert (string.matches("-[^-].*"));
                object2 = string.substring(1);
                if (this.optionsByString.containsKey(object2)) {
                    object = parserState.onStartOption(string, (String)object2);
                    parserState = ((OptionParserState)object).onStartNextArg();
                    continue;
                }
                object = string.substring(1, 2);
                if (this.optionsByString.containsKey(object)) {
                    optionParserState = parserState.onStartOption("-" + (String)object, (String)object);
                    if (optionParserState.getHasArgument()) {
                        parserState = optionParserState.onArgument(string.substring(2));
                        continue;
                    }
                    parserState = optionParserState.onComplete();
                    for (int i = 2; i < string.length(); ++i) {
                        String string2 = string.substring(i, i + 1);
                        optionParserState = parserState.onStartOption("-" + string2, string2);
                        parserState = optionParserState.onComplete();
                    }
                    continue;
                }
                if (this.allowUnknownOptions) {
                    optionParserState = parserState.onStartOption(string, (String)object2);
                    parserState = optionParserState.onComplete();
                    continue;
                }
                optionParserState = parserState.onStartOption("-" + (String)object, (String)object);
                parserState = optionParserState.onComplete();
                continue;
            }
            parserState = parserState.onNonOption(string);
        }
        parserState.onCommandLineEnd();
        return parsedCommandLine;
    }

    public CommandLineParser allowMixedSubcommandsAndOptions() {
        this.allowMixedOptions = true;
        return this;
    }

    public CommandLineParser allowUnknownOptions() {
        this.allowUnknownOptions = true;
        return this;
    }

    public void printUsage(OutputStream outputStream) {
        Formatter formatter = new Formatter(outputStream);
        TreeSet<CommandLineOption> treeSet = new TreeSet<CommandLineOption>(new OptionComparator());
        treeSet.addAll(this.optionsByString.values());
        LinkedHashMap<Object, String> linkedHashMap = new LinkedHashMap<Object, String>();
        for (CommandLineOption iterator : treeSet) {
            String string;
            Map.Entry entry = new TreeSet<String>(new OptionStringComparator());
            entry.addAll(iterator.getOptions());
            ArrayList<String> arrayList = new ArrayList<String>();
            Object object = entry.iterator();
            while (object.hasNext()) {
                string = (String)object.next();
                if (string.length() == 1) {
                    arrayList.add("-" + string);
                    continue;
                }
                arrayList.add("--" + string);
            }
            object = CommandLineParser.join(arrayList, ", ");
            string = iterator.getDescription();
            if (string == null || string.length() == 0) {
                string = "";
            }
            linkedHashMap.put(object, string);
        }
        int n = 0;
        for (Map.Entry entry : linkedHashMap.keySet()) {
            n = Math.max(n, ((String)((Object)entry)).length());
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            if (((String)entry.getValue()).length() == 0) {
                formatter.format("%s%n", entry.getKey());
                continue;
            }
            formatter.format("%-" + n + "s  %s%n", entry.getKey(), entry.getValue());
        }
        formatter.flush();
    }

    private static String join(Collection<?> collection, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        if (string == null) {
            string = "";
        }
        for (Object obj : collection) {
            if (!bl) {
                stringBuffer.append(string);
            }
            stringBuffer.append(obj.toString());
            bl = false;
        }
        return stringBuffer.toString();
    }

    public CommandLineOption option(String ... stringArray) {
        for (String string : stringArray) {
            if (this.optionsByString.containsKey(string)) {
                throw new IllegalArgumentException(String.format("Option '%s' is already defined.", string));
            }
            if (!string.startsWith("-")) continue;
            throw new IllegalArgumentException(String.format("Cannot add option '%s' as an option cannot start with '-'.", string));
        }
        CommandLineOption commandLineOption = new CommandLineOption(Arrays.asList(stringArray));
        for (String string : commandLineOption.getOptions()) {
            this.optionsByString.put(string, commandLineOption);
        }
        return commandLineOption;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OptionStringComparator
    implements Comparator<String> {
        private OptionStringComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            boolean bl;
            boolean bl2 = string.length() == 1;
            boolean bl3 = bl = string2.length() == 1;
            if (bl2 && !bl) {
                return -1;
            }
            if (!bl2 && bl) {
                return 1;
            }
            return new CaseInsensitiveStringComparator().compare(string, string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CaseInsensitiveStringComparator
    implements Comparator<String> {
        private CaseInsensitiveStringComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            int n = string.compareToIgnoreCase(string2);
            if (n != 0) {
                return n;
            }
            return string.compareTo(string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OptionComparator
    implements Comparator<CommandLineOption> {
        private OptionComparator() {
        }

        @Override
        public int compare(CommandLineOption commandLineOption, CommandLineOption commandLineOption2) {
            String string = Collections.min(commandLineOption.getOptions(), new OptionStringComparator());
            String string2 = Collections.min(commandLineOption2.getOptions(), new OptionStringComparator());
            return new CaseInsensitiveStringComparator().compare(string, string2);
        }
    }

    private static class UnknownOptionParserState
    extends OptionParserState {
        private final ParserState state;
        private final String arg;
        private final ParsedCommandLine commandLine;

        private UnknownOptionParserState(String string, ParsedCommandLine parsedCommandLine, ParserState parserState) {
            this.arg = string;
            this.commandLine = parsedCommandLine;
            this.state = parserState;
        }

        public boolean getHasArgument() {
            return true;
        }

        public ParserState onStartNextArg() {
            return this.onComplete();
        }

        public ParserState onArgument(String string) {
            return this.onComplete();
        }

        public ParserState onComplete() {
            this.commandLine.addExtraValue(this.arg);
            return this.state;
        }
    }

    private class KnownOptionParserState
    extends OptionParserState {
        private final OptionString optionString;
        private final CommandLineOption option;
        private final ParsedCommandLine commandLine;
        private final ParserState state;
        private final List<String> values;

        private KnownOptionParserState(OptionString optionString, CommandLineOption commandLineOption, ParsedCommandLine parsedCommandLine, ParserState parserState) {
            this.values = new ArrayList<String>();
            this.optionString = optionString;
            this.option = commandLineOption;
            this.commandLine = parsedCommandLine;
            this.state = parserState;
        }

        public ParserState onArgument(String string) {
            if (!this.getHasArgument()) {
                throw new CommandLineArgumentException(String.format("Command-line option '%s' does not take an argument.", this.optionString));
            }
            if (string.length() == 0) {
                throw new CommandLineArgumentException(String.format("An empty argument was provided for command-line option '%s'.", this.optionString));
            }
            this.values.add(string);
            return this.onComplete();
        }

        public ParserState onStartNextArg() {
            if (this.option.getAllowsArguments() && this.values.isEmpty()) {
                return new MissingOptionArgState(this);
            }
            return this.onComplete();
        }

        public boolean getHasArgument() {
            return this.option.getAllowsArguments();
        }

        public ParserState onComplete() {
            if (this.getHasArgument() && this.values.isEmpty()) {
                throw new CommandLineArgumentException(String.format("No argument was provided for command-line option '%s'.", this.optionString));
            }
            ParsedCommandLineOption parsedCommandLineOption = this.commandLine.addOption(this.optionString.option, this.option);
            if (this.values.size() + parsedCommandLineOption.getValues().size() > 1 && !this.option.getAllowsMultipleArguments()) {
                throw new CommandLineArgumentException(String.format("Multiple arguments were provided for command-line option '%s'.", this.optionString));
            }
            for (String string : this.values) {
                parsedCommandLineOption.addArgument(string);
            }
            if (this.option.getDeprecationWarning() != null) {
                CommandLineParser.this.deprecationPrinter.println("The " + this.optionString + " option is deprecated - " + this.option.getDeprecationWarning());
            }
            if (this.option.getSubcommand() != null) {
                return this.state.onNonOption(this.option.getSubcommand());
            }
            return this.state;
        }
    }

    private static abstract class OptionParserState {
        private OptionParserState() {
        }

        public abstract ParserState onStartNextArg();

        public abstract ParserState onArgument(String var1);

        public abstract boolean getHasArgument();

        public abstract ParserState onComplete();
    }

    private static class MissingOptionArgState
    extends ParserState {
        private final OptionParserState option;

        private MissingOptionArgState(OptionParserState optionParserState) {
            this.option = optionParserState;
        }

        public boolean maybeStartOption(String string) {
            return this.isOption(string);
        }

        public OptionParserState onStartOption(String string, String string2) {
            return this.option.onComplete().onStartOption(string, string2);
        }

        public ParserState onNonOption(String string) {
            return this.option.onArgument(string);
        }

        public void onCommandLineEnd() {
            this.option.onComplete();
        }
    }

    private static class AfterOptions
    extends ParserState {
        private final ParsedCommandLine commandLine;

        private AfterOptions(ParsedCommandLine parsedCommandLine) {
            this.commandLine = parsedCommandLine;
        }

        public boolean maybeStartOption(String string) {
            return false;
        }

        public OptionParserState onStartOption(String string, String string2) {
            return new UnknownOptionParserState(string, this.commandLine, this);
        }

        public ParserState onNonOption(String string) {
            this.commandLine.addExtraValue(string);
            return this;
        }
    }

    private class AfterFirstSubCommand
    extends OptionAwareParserState {
        private AfterFirstSubCommand(ParsedCommandLine parsedCommandLine) {
            super(parsedCommandLine);
        }

        public OptionParserState onStartOption(String string, String string2) {
            CommandLineOption commandLineOption = (CommandLineOption)CommandLineParser.this.optionsByString.get(string2);
            if (commandLineOption == null) {
                return new UnknownOptionParserState(string, this.commandLine, this);
            }
            return new KnownOptionParserState(new OptionString(string, string2), commandLineOption, this.commandLine, this);
        }
    }

    private class BeforeFirstSubCommand
    extends OptionAwareParserState {
        private BeforeFirstSubCommand(ParsedCommandLine parsedCommandLine) {
            super(parsedCommandLine);
        }

        public OptionParserState onStartOption(String string, String string2) {
            OptionString optionString = new OptionString(string, string2);
            CommandLineOption commandLineOption = (CommandLineOption)CommandLineParser.this.optionsByString.get(string2);
            if (commandLineOption == null) {
                if (CommandLineParser.this.allowUnknownOptions) {
                    return new UnknownOptionParserState(string, this.commandLine, this);
                }
                throw new CommandLineArgumentException(String.format("Unknown command-line option '%s'.", optionString));
            }
            return new KnownOptionParserState(optionString, commandLineOption, this.commandLine, this);
        }
    }

    private abstract class OptionAwareParserState
    extends ParserState {
        protected final ParsedCommandLine commandLine;

        protected OptionAwareParserState(ParsedCommandLine parsedCommandLine) {
            this.commandLine = parsedCommandLine;
        }

        public boolean maybeStartOption(String string) {
            return this.isOption(string);
        }

        public ParserState onNonOption(String string) {
            this.commandLine.addExtraValue(string);
            return CommandLineParser.this.allowMixedOptions ? new AfterFirstSubCommand(this.commandLine) : new AfterOptions(this.commandLine);
        }
    }

    private static abstract class ParserState {
        private ParserState() {
        }

        public abstract boolean maybeStartOption(String var1);

        boolean isOption(String string) {
            return string.matches("-.+");
        }

        public abstract OptionParserState onStartOption(String var1, String var2);

        public abstract ParserState onNonOption(String var1);

        public void onCommandLineEnd() {
        }
    }

    private static class OptionString {
        private final String arg;
        private final String option;

        private OptionString(String string, String string2) {
            this.arg = string;
            this.option = string2;
        }

        public String getDisplayName() {
            return this.arg.startsWith("--") ? "--" + this.option : "-" + this.option;
        }

        public String toString() {
            return this.getDisplayName();
        }
    }
}

